document.addEventListener("DOMContentLoaded", () => {

    // --- Accordéons ---
    document.querySelectorAll('.accordeon').forEach(element => {
        element.classList.add('active'); // Tous ouverts au chargement
        element.querySelector('.accordeon-header').addEventListener('click', () => {
            element.classList.toggle('active'); // Comportement indépendant
        });
    });

    // --- Scroll Header + Fading Carrousel ---
    const header = document.querySelector(".header");
    const div = document.querySelector(".carrousel");
    const toFade = document.querySelectorAll(".toFade");

    window.addEventListener("scroll", () => {
        const scrollTop = window.scrollY;
        const divHeight = div.offsetHeight;
        let opacity = 1 - ((scrollTop / divHeight) * 1.5);
        opacity = Math.max(0, Math.min(1, opacity));

        if (window.innerWidth > 768) {
            toFade.forEach(elem => elem.style.opacity = opacity);
        }

        header.classList.toggle("scrolled", scrollTop > 100);
    });

    // --- Loader Principal ---
    const loader = document.getElementById("loader");
    if (loader) {
        setTimeout(() => {
            loader.style.transition = "opacity 0.5s ease-out";
            loader.style.opacity = "0";
            setTimeout(() => loader.style.display = "none", 500);
        }, 1400);
    }

    // --- Carte Leaflet ---
    const coords = [5.296592392673111, -3.984974034738098];
    const mapId = window.innerWidth < 768 ? 'map_mobile' : 'map';
    const map = L.map(mapId).setView(coords, 14);

    const markerIcon = L.icon({
        iconUrl: "/assets/medias/icones/pl_markerIcon.png", // Attention au chemin si compilé avec Webpack
        iconSize: [65, 65],
        iconAnchor: [32, 65],
    });

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors',
        maxZoom: 18
    }).addTo(map);

    L.marker(coords, { alt: 'Le Passage Lumière', icon: markerIcon })
        .addTo(map)
        .bindPopup('Le Passage Lumière, est là ! <br><a target="_blank" href="https://maps.app.goo.gl/TSonjbucLwGAV36x6">Google maps</a>');

    // --- Modal ---
    const modal = document.getElementById("modal");
    const messageContainer = document.getElementById("modal-message");
    const closeModal = () => modal.className = "modal";

    window.showModal = (message, type) => {
        messageContainer.textContent = message;
        modal.className = `modal show ${type}`;
        setTimeout(closeModal, 4000);
    };

    document.querySelector('.close-btn')?.addEventListener('click', closeModal);

    // --- Formulaire AJAX ---
    $("#contactForm").on("submit", function (event) {
        event.preventDefault();

        const requiredFields = ["#nomEntreprise", "#nomPrenom", "#email", "#telephone", "#activite"];
        const values = requiredFields.map(sel => $(sel).val().trim());

        if (values.some(v => !v)) {
            showModal("Tous les champs sont obligatoires.", "error");
            return;
        }

        $("#f_loader").show();

        const formData = {};
        $(this).serializeArray().forEach(field => formData[field.name] = field.value);

        $.ajax({
            url: "https://www.lebadamier.com/api/set-contact",
            type: "POST",
            contentType: "application/json",
            data: JSON.stringify(formData),
            dataType: "json",
            success: response => {
                $("#f_loader").hide();
                if (response.success) {
                    showModal(response.message, "success");
                    this.reset();
                } else {
                    showModal("Erreur : " + response.errors.join('\n'), "error");
                }
            },
            error: xhr => {
                $("#f_loader").hide();
                showModal("Erreur de connexion avec le serveur ! \n" + xhr.responseText, "error");
            }
        });
    });

    $('.navbar__menu li a, .btn__menu').click(function() {
        if (window.innerWidth < 768) $('.header').toggleClass('is-menuDisplayed');
    })
});